System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, _decorator, Component, Node, log, UITransform, Vec3, resources, Prefab, instantiate, _dec, _class, _temp, _crd, ccclass, property, setNode;

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Node = _cc.Node;
      log = _cc.log;
      UITransform = _cc.UITransform;
      Vec3 = _cc.Vec3;
      resources = _cc.resources;
      Prefab = _cc.Prefab;
      instantiate = _cc.instantiate;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "06a4coyXQ9OY6m3q8gK0+fe", "setNode", undefined);

      ({
        ccclass,
        property
      } = _decorator);

      _export("setNode", setNode = (_dec = ccclass('setNode'), _dec(_class = (_temp = class setNode extends Component {
        constructor() {
          super(...arguments);

          _defineProperty(this, "del", null);

          _defineProperty(this, "left", null);

          _defineProperty(this, "right", null);

          _defineProperty(this, "add", null);

          _defineProperty(this, "widePlus", null);

          _defineProperty(this, "highPlus", null);

          _defineProperty(this, "wideReduce", null);

          _defineProperty(this, "highReduce", null);

          _defineProperty(this, "needToSet", null);

          _defineProperty(this, "addNum", 1);
        }

        //添加次数
        onLoad() {
          this.del = this.node.getChildByName('delete'); //获取删除按钮

          this.left = this.node.getChildByName('left'); //获取左转按钮

          this.right = this.node.getChildByName('right'); //获取右转按钮

          this.add = this.node.getChildByName('add'); //获取添加按钮

          this.widePlus = this.node.getChildByName('wide+'); //获取添加按钮

          this.highPlus = this.node.getChildByName('high+'); //获取添加按钮

          this.wideReduce = this.node.getChildByName('wide-'); //获取添加按钮

          this.highReduce = this.node.getChildByName('high-'); //获取添加按钮

          this.del.on(Node.EventType.TOUCH_START, () => {
            if (this.needToSet != null) {
              this.needToSet.destroy();
              this.needToSet = null;
              this.node.active = false;
            }
          }, this); //监听删除按钮点击结束事件

          this.left.on(Node.EventType.TOUCH_START, () => {
            if (this.needToSet != null) {
              this.needToSet.setRotationFromEuler(0, 0, this.needToSet.angle + 10);
            }
          }, this); //监听左边按钮点击开始事件

          this.right.on(Node.EventType.TOUCH_START, () => {
            if (this.needToSet != null) {
              this.needToSet.setRotationFromEuler(0, 0, this.needToSet.angle - 10);
            }
          }, this); //监听右转按钮点击开始事件

          this.add.on(Node.EventType.TOUCH_START, this.newNode, this); //监听增加按钮点击结束事件

          this.widePlus.on(Node.EventType.TOUCH_START, () => {
            this.setSize(this.widePlus);
          }, this); //监听宽度增加按钮点击开始事件

          this.wideReduce.on(Node.EventType.TOUCH_START, () => {
            this.setSize(this.wideReduce);
          }, this); //监听宽度增加按钮点击开始事件

          this.highPlus.on(Node.EventType.TOUCH_START, () => {
            this.setSize(this.highPlus);
          }, this); //监听宽度增加按钮点击开始事件

          this.highReduce.on(Node.EventType.TOUCH_START, () => {
            this.setSize(this.highReduce);
          }, this); //监听宽度增加按钮点击开始事件
        }

        onEnable() {
          this.add.on(Node.EventType.TOUCH_START, this.newNode, this); //监听增加按钮点击结束事件
        }

        onDisable() {
          this.needToSet = null;
          this.del.off(Node.EventType.TOUCH_START, () => {
            if (this.needToSet != null) {
              this.needToSet.destroy();
              this.needToSet = null;
              this.node.active = false;
            }
          }, this); //取消监听删除按钮点击结束事件

          this.left.off(Node.EventType.TOUCH_START, () => {
            if (this.needToSet != null) {
              this.needToSet.setRotationFromEuler(0, 0, this.needToSet.angle + 10);
            }
          }, this); //取消监听左边按钮点击开始事件

          this.right.off(Node.EventType.TOUCH_START, () => {
            if (this.needToSet != null) {
              this.needToSet.setRotationFromEuler(0, 0, this.needToSet.angle - 10);
            }
          }, this); //取消监听右转按钮点击开始事件

          this.add.off(Node.EventType.TOUCH_START, this.newNode, this); //取消监听增加按钮点击结束事件

          this.widePlus.off(Node.EventType.TOUCH_START, () => {
            this.setSize(this.widePlus);
          }, this); //监听宽度增加按钮点击开始事件

          this.wideReduce.off(Node.EventType.TOUCH_START, () => {
            this.setSize(this.wideReduce);
          }, this); //监听宽度增加按钮点击开始事件

          this.highPlus.off(Node.EventType.TOUCH_START, () => {
            this.setSize(this.highPlus);
          }, this); //监听宽度增加按钮点击开始事件

          this.highReduce.off(Node.EventType.TOUCH_START, () => {
            this.setSize(this.highReduce);
          }, this); //监听宽度增加按钮点击开始事件
        }
        /**
         * 设置
         * @param node 需要被设置的节点
         */


        set(node) {
          this.needToSet = node; //获取被设置节点

          var needNodeSize = this.needToSet.getComponent(UITransform).contentSize; //获取被设置节点尺寸

          var worldPos = this.needToSet.getWorldPosition(); //获取需要被设置的节点世界位置

          this.node.setWorldPosition(worldPos.x, worldPos.y + needNodeSize.width, worldPos.z); //设置此节点至被设置节点的世界位置

          this.addNum = 0; //初始化添加次数
        }
        /**
         * 添加新节点
         */


        newNode() {
          log('添加');
          var newNodeParent = this.needToSet.parent; //获取被设置节点的父节点

          var needToSetPos = this.needToSet.getPosition(); //被设置节点位置

          var needNodeSize = this.needToSet.getComponent(UITransform).contentSize; //获取被设置节点尺寸

          resources.load("prefab/" + this.needToSet.name, Prefab, (err, prefab) => {
            //获取预制体资源
            var newNode = instantiate(prefab); //实例化预制体资源

            newNodeParent.addChild(newNode); //添加子节点

            newNode.getComponent(UITransform).setContentSize(needNodeSize);
            var newNodeX = newNode.getComponent(UITransform).contentSize.x; //获取新节点的x轴长度

            var newNodepos = new Vec3(needToSetPos.x + newNodeX * this.addNum, needToSetPos.y, needToSetPos.z); //获取新节点需要放置的位置

            newNode.setPosition(newNodepos); //新节点设置位置
          });
          this.addNum += 1; //添加次数+1
        }
        /**
         * 设置尺寸
         * @param node 被设置节点
         */


        setSize(node) {
          var uiTransform = this.needToSet.getComponent(UITransform); //获取被设置节点变换组件

          var size = uiTransform.contentSize; //获取被设置节点尺寸

          if (node == this.widePlus) {
            uiTransform.setContentSize(size.width + 10, size.height); //宽度+10
          } else if (node == this.highPlus) {
            uiTransform.setContentSize(size.width, size.height + 10); //高度+10

            var pos = this.node.getPosition(); //获取自身节点位置

            this.node.setPosition(pos.x, pos.y + 5, pos.z); //本节点y轴+5
          } else if (node == this.wideReduce) {
            uiTransform.setContentSize(size.width - 10, size.height); //宽度-10
          } else {
            uiTransform.setContentSize(size.width, size.height - 10); //高度-10

            var _pos = this.node.getPosition(); //获取自身节点位置


            this.node.setPosition(_pos.x, _pos.y - 5, _pos.z); //本节点y轴-5
          }
        }

      }, _temp)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=setNode.js.map